// $Id: CWaveCycle.cpp,v 1.3 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CWaveCycle.hpp"
using Exponent::GUI::Controls::CWaveCycle;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CWaveCycle, CControl);

//	===========================================================================
CWaveCycle::CWaveCycle(IControlRoot *root, const long uniqueId, const CRect &area) 
		  : CControl(root, uniqueId, area), m_wave(area.getWidth())
		  , m_position(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CWaveCycle);

	// Default the line to zero
	for (long i = 0; i < m_area.getWidth(); i++)
	{
		m_wave.setPoint(CPoint(i, m_area.getHeight()), i);
	}
}

//	===========================================================================
CWaveCycle::~CWaveCycle() 
{ 
	EXPONENT_CLASS_DESTRUCTION(CWaveCycle);
}

//	===========================================================================
void CWaveCycle::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Draw the waveform
	graphics.getMutablePen()->setColour(CAlphaColour(118, 147, 171));
	graphics.drawPolygon(m_wave);

	graphics.getMutablePen()->setColour(CAlphaColour::CALPHACOLOUR_ORANGE);
	graphics.drawLine(CPoint(m_position, 0), CPoint(m_position, m_area.getHeight()));
}

//	===========================================================================
void CWaveCycle::setNextValue(const double value)
{
	// Store the pointer
	m_wave.setPoint(CPoint(m_position, (long)((1.0 - value) * m_area.getHeight())), m_position);

	// Increment and check the position
	if (++m_position >= m_area.getWidth())
	{
		m_position = 0;
	}

	// Reset the next value
	m_wave.setPoint(CPoint(m_position, m_area.getHeight()), m_position);
}